IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES
			 WHERE TABLE_NAME='CTB_CENTRO_CUSTO_PRC_FILIAL')
BEGIN
CREATE TABLE [dbo].[CTB_CENTRO_CUSTO_PRC_FILIAL](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_CENTRO_CTB] [int] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NULL,
 CONSTRAINT [PK_CTB_CENTRO_CUSTO_PRC_FILIAL] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_CENTRO_CTB] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[CTB_CENTRO_CUSTO_PRC_FILIAL] ADD  CONSTRAINT [DF_CTB_CENTRO_CUSTO_PRC_FILIAL_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[CTB_CENTRO_CUSTO_PRC_FILIAL] ADD  CONSTRAINT [DF_CTB_CENTRO_CUSTO_PRC_FILIAL_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[CTB_CENTRO_CUSTO_PRC_FILIAL] ADD  CONSTRAINT [DF_CTB_CENTRO_CUSTO_PRC_FILIAL_CD_CENTRO_CTB]  DEFAULT ((0)) FOR [CD_CENTRO_CTB]

ALTER TABLE [dbo].[CTB_CENTRO_CUSTO_PRC_FILIAL] ADD  CONSTRAINT [DF_CTB_CENTRO_CUSTO_PRC_FILIAL_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[CTB_CENTRO_CUSTO_PRC_FILIAL]  WITH CHECK ADD  CONSTRAINT [FK_CTB_CENTRO_CUSTO_PRC_FILIAL_CTB_CENTRO_CUSTO] FOREIGN KEY([CD_EMP], [CD_CENTRO_CTB])
REFERENCES [dbo].[CTB_CENTRO_CUSTO] ([CD_EMP], [CD_CENTRO_CTB])

ALTER TABLE [dbo].[CTB_CENTRO_CUSTO_PRC_FILIAL] CHECK CONSTRAINT [FK_CTB_CENTRO_CUSTO_PRC_FILIAL_CTB_CENTRO_CUSTO]
end

